/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ***********************************************************************
   *                                                                     *
   * regxdir.h                                                           *
   * Christian Zurhorst, BID R&D, 3. Sep. 1997                           *
   *                                                                     *
   * defines for first command byte                                      *
   *                                                                     *
   ***********************************************************************

// naming conventions
// The new 16-bit register file requires commands to be grouped according to
// their related resource and function. Therefore each command consists of
// a group identifier byte, beginning with CMDG_, and a group member byte
// beginning with CMDM_
*/

#ifndef __REGXDIR_H
#define __REGXDIR_H


#define NO_COMMAND			0x0000
#define CMD_MERGE(group, modifier)	(b_int16)((((b_int16)(group)) << 8) | (modifier))

/*
// segmentation of the register file

// 00 - 0F
// segment reserved for compatibility reasons. Communication according to
// old protocol.
*/ /*
// group 10
// The members of this group do not require CAPI license
*/

#define CMDG_FREEACCESS			0x10

/*
// group 11
//
*/

#define CMDG_SERVICES			0x11

#define CMDG_BOARDSETTINGS		0x12

#define CMDG_MAILBOX_LOCK		0x14
#define CMDG_MAILBOX_NOLOCK		0x15

#define CMDG_CPUPORT_ACTION_LOCK	0x1a
#define CMDG_CPUPORT_ACTION_NOLOCK	0x1b
#define CMDG_CPUPORT_SET	 	    0x1c
#define CMDG_CPUPORT_GET		    0x1d

#define CMDG_EXEACTION_LOCK		0x20
#define CMDG_EXEACTION_NOLOCK		0x21
#define CMDG_EXESET_0			0x22
#define CMDG_EXEGET_0			0x23
#define CMDG_EXESET_1			0x24
#define CMDG_EXEGET_1			0x25

#define CMDG_BITEST_0     0x26  /* built-in-tests */

#define CMDG_TRACEACTION_LOCK		0x30
#define CMDG_TRACEACTION_NOLOCK		0x31
#define CMDG_TRACESET_0			0x32
#define CMDG_TRACEGET_0			0x33

#define CMDG_OBSACTION_LOCK		0x38
#define CMDG_OBSACTION_NOLOCK     	0x39
#define CMDG_OBSSET_0     		0x3a
#define CMDG_OBSGET_0     		0x3b

#define CMDG_TCACTION_LOCK		0x3c
#define CMDG_TCACTION_NOLOCK     	0x3d
#define CMDG_TCSET_0     		0x3e
#define CMDG_TCGET_0     		0x3f

#define CMDG_PERFACTION_LOCK		0x40
#define CMDG_PERFACTION_NOLOCK		0x41
#define CMDG_PERFORMANCESET_0		0x42
#define CMDG_PERFORMANCEGET_0		0x43

#define CMDG_EXEFHIFACTION_LOCK		0x50
#define CMDG_EXEFHIFACTION_NOLOCK	0x51
#define CMDG_EXEFHIF_SET                0x52
#define CMDG_EXEFHIF_GET	        0x53

#define CMDG_SSTACTION_LOCK    		0x60
#define CMDG_SSTACTION_NOLOCK		0x61
#define CMDG_SSTSET_0			0x62
#define CMDG_SSTGET_0			0x63

#define CMDG_STATIO_ACTION_LOCK		0x6a
#define CMDG_STATIO_ACTION_NOLOCK	0x6b
#define CMDG_STATIO_SET		        0x6c
#define CMDG_STATIO_GET		        0x6d

#define CMDG_RAPIDFW_ACTION_LOCK	0x70

#define     CMDM_LOCK			0x01
#define	      IN_LOCK			 0
#define       OUT_LOCK			 0
#define     CMDM_UNLOCK			0x02
#define       IN_UNLOCK                  0
#define       OUT_UNLOCK		 0


/*
// group 80 .. A9, pattern set groups
// these groups have similar entries that require the same parameters for
// according members in the group. The correct group number is calculated by
// adding  the enum below to the command group
*/

#define CMDG_PATT_SET			0x80
#define   CMDM_PATT_SET      		0x05
#define   IN_PATT_SET	        	B_LENGTH_NEGOTIATE
#define   OUT_PATT_SET	        	 0


/*
// group AA
// a pattern has basically only one get command. The enum below specifies the
// group member.
*/

#define CMDG_PATT_GET			0xAA
#define	  CMDM_PATT_GET			0x05
#define     CMD_PATT_GET		CMD_MERGE (CMDG_PATT_GET, CMDM_PATT_GET)

#define   CMDM_PATT_EDIT_GET		0x85
#define     CMD_PATT_EDIT_GET		CMD_MERGE (CMDG_PATT_GET, CMDM_PATT_EDIT_GET)

#define   IN_PATT_GET	        	 1
#define   OUT_PATT_GET	        	B_LENGTH_NEGOTIATE


#endif



